#!/bin/bash

# Define the path to your Node.js project directory
PROJECT_DIR="/www/wwwroot/bdggame"
# Define the command to start your Node.js project
START_COMMAND="node src/server.js"

# Define a unique identifier for your project
UNIQUE_IDENTIFIER="node src/server.js"

# Navigate to the project directory
cd "$PROJECT_DIR" || exit

# Check if the process with the unique identifier is running
if ! pgrep -f "$UNIQUE_IDENTIFIER" > /dev/null; then
  echo "$(date): Node.js project is not running. Starting it now..." >> "$PROJECT_DIR/project_monitor.log"
  $START_COMMAND &
else
  echo "$(date): Node.js project is already running." >> "$PROJECT_DIR/project_monitor.log"
fi
